/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * JDBCドライバリソース取得クラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JdbcDriverUtil {
    private static ResourceBundle m_bundle = ResourceBundle.getBundle("jdbc");

    private static final String JDBC_DRIVER = "jdbc.driver";
    private static final String JDBC_DRIVER_NAME = "jdbc.driver.name.";
    private static final String JDBC_DRIVER_CLASSNAME = "jdbc.driver.classname.";
    
    private JdbcDriverUtil() {

    }

    /**
     * JDBCドライバ名、クラス名を取得
     * 
     * @return JDBCドライバ一覧
     */
    public static List<List<String>> getJdbcDriver() {
    	List<List<String>> list = new ArrayList<List<String>>();
    	
    	Integer count;
		try {
			count = Integer.valueOf(m_bundle.getString(JDBC_DRIVER));
		} catch (MissingResourceException e) {
			count = new Integer(0);
		}
    	
    	for(int i = 1; i <= count.intValue(); i++){
    		List<String> driver = new ArrayList<String>();
    		driver.add(m_bundle.getString(JDBC_DRIVER_NAME + i));
    		driver.add(m_bundle.getString(JDBC_DRIVER_CLASSNAME + i));
    		list.add(driver);
    	}
    	return list;
    }
}