/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.repository;

import java.util.ArrayList;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * スコープ情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteScope {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteScope.class);

	/**
	 * スコープ情報を削除する。<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("Scope.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//スコープリスト取得
		ArrayList<ScopeInfo> scopeList = getScopeList();

		for(ScopeInfo scope : scopeList){
			String id = scope.getFacilityId();
			if(!id.matches("(INTERNAL|REGISTERED|UNREGISTERED)")){
				deleteScopeInfo(id);
			}
		}

		log.info(Messages.getMsg("Scope.End", new String[]{Messages.getMsg("ImportTool.Delete")}));

	}

	/**
	 * スコープ情報を削除する。<br>
	 * 
	 * @param facilityId ファシリティID
	 */
	protected void deleteScopeInfo(String facilityId) {
		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		try {
			Object[] args = {facilityId};
			log.info(Messages.getMsg("FacilityID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			repository.deleteScope(facilityId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * スコープリストを取得する。<br>
	 * 
	 * @return スコープリスト
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList<ScopeInfo> getScopeList() {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		ArrayList<ScopeInfo> scopeList = null;
		try {
			scopeList = repository.getScopeList("");
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return scopeList;
	}
}