/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.job;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.ejb.session.JobController;

/**
 * スケジュール情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidSchedule {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidSchedule.class);

	/**
	 * スケジュール情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Job.Schedule.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getScheduleList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				JobSchedule line = (JobSchedule)itr.next();

				//有効/無効
				line.setValid(ValidConstant.booleanToType(valid));

				changeSchedule(line);
			}
		}

		log.info(Messages.getMsg("Job.Schedule.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * スケジュールの有効・無効を変更する。<br>
	 * 
	 * @param info スケジュール情報
	 */
	protected void changeSchedule(JobSchedule info) {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		try {
			Object[] args = {info.getId()};
			log.info(Messages.getMsg("ScheduleID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			job.modifySchedule(info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * スケジュール一覧を取得する。<br>
	 * 
	 * @return スケジュール一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getScheduleList() {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		ArrayList list = null;
		try {
			list = job.getScheduleList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return list;
	}
}