/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.repository;

import java.util.ArrayList;
import java.util.Locale;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノード情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidNode {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidNode.class);

	/**
	 * ノード監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Node.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList<Property> nodeList = getNodeList();

		for(Property property : nodeList){
			//管理対象
			ArrayList propertyList = PropertyUtil.getProperty(property, NodeProperty.VALID);
			((Property)propertyList.get(0)).setValue(valid);

			changeNodeInfo(property);
		}

		log.info(Messages.getMsg("Node.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * ノード情報の有効・無効を変更する。<br>
	 * 
	 * @param property ノード情報
	 */
	protected void changeNodeInfo(Property property) {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		@SuppressWarnings("unchecked")
		ArrayList propertyList = null;

		propertyList = PropertyUtil.getProperty(property, NodeProperty.FACILITY_ID);
		String facilityId = (String)((Property)propertyList.get(0)).getValue();

		try {
			Object[] args = {facilityId};
			log.info(Messages.getMsg("FacilityID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			repository.modifyNode(property);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}
	
	/**
	 * ファシリティリストを取得する。<br>
	 * 
	 * @return ファシリティ一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList<Property> getNodeList() {

		RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

		ArrayList<Property> nodeList = new ArrayList<Property>();
		try {
			ArrayList<String> records = repository.getNodeFacilityIdList();
			for(String facilityId : records){
				Property node = repository.getNodeProperty(facilityId, PropertyConstant.MODE_MODIFY, Locale.getDefault());
				nodeList.add(node);
			}
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return nodeList;
	}
}