/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;

/**
 * HTTP監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorHttpString extends ExportMonitorString {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportMonitorHttpString.class);

	/**
	 * HTTP監視情報をExportする。<br>
	 */
	public void exportHttp() {
		log.info(Messages.getMsg("Http.Start", new String[]{Messages.getMsg("ExportTool.Export")}));

		//CSV出力配列を用意
		ArrayList<ArrayList<String>> csvMainOutput = new ArrayList<ArrayList<String>>();
		ArrayList<ArrayList<String>> csvRuleOutput = new ArrayList<ArrayList<String>>();

		//監視項目リスト取得
		ArrayList idList = getHttpList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				int monitorType = MonitorTypeConstant.stringToType((String)line.get(3));
				if(monitorType == MonitorTypeConstant.TYPE_STRING){
					Object[] args = {(String)line.get(0)};
					log.info(Messages.getMsg("MonitorID", args));

					MonitorInfo info = getHttp((String)line.get(0), monitorType);
					csvMainOutput.add(createCsvFormat(info));
					csvRuleOutput.addAll(createMonitorJudgement(info));
				}
			}

			//監視項目IDでソート
			Collections.sort(csvMainOutput, new StringListComparator(0));

			//監視項目IDと順序でソート
			Collections.sort(csvRuleOutput, new IntegerListComparator(1));
			Collections.sort(csvRuleOutput, new StringListComparator(0));
		}

		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/HTTP_STR_" + format.format(new Date()) + ".csv", 
				csvMainOutput);

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/HTTP_STR_RULE_" + format.format(new Date()) + ".csv", 
				csvRuleOutput);

		log.info(Messages.getMsg("Http.End", new String[]{Messages.getMsg("ExportTool.Export")}));
	}

	/**
	 * HTTP監視情報をExportする。<br>
	 * 
	 * @param monitorInfo HTTP監視情報
	 * @return CSVフォーマット文字列
	 * 
	 * @see jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitor#createMonitorInfo(com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		MonitorHttpInfo httpInfo = (MonitorHttpInfo)monitorInfo.getCheckInfo();
		if(httpInfo == null){
			httpInfo = new MonitorHttpInfo();
		}
		//URL
		if (httpInfo.getRequestUrl() != null)
			csvFormat.add(httpInfo.getRequestUrl());
		else
			csvFormat.add("");
		//タイムアウト
		csvFormat.add(String.valueOf(httpInfo.getTimeout()));

		return csvFormat;
	}

	/**
	 * HTTP監視情報を取得する。<br>
	 * 
    /**
	 * @param monitorId 取得対象の監視項目ID
	 * @param monitorType 取得対象の監視種別
	 * @return HTTP監視情報
	 */
	protected MonitorInfo getHttp(String monitorId, int monitorType) {

		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		MonitorInfo info = null;
		try {
			info = http.getHttpInfo(monitorId, monitorType);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	protected ArrayList getHttpList() {

		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		ArrayList records = null;
		try {
			records = http.getHttpList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}