/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.util;



/**
 * 文字列をチェック・変換するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckString {

	/**
	 * 改行が含まれていないかチェックし、改行が含まれている場合、前後に"を付加する。<br>
	 * 
	 * @param value チェック対象文字列
	 * @return　文字列
	 */
	public static String checkReturn(String value){

		if(value instanceof String && value.indexOf("\n") >= 0)
			return "\"" + value + "\"";
		else
			return value;
	}

	/**
	 * 文字列長チェック<br>
	 * 
	 * @param value チェック対象文字列
	 * @param length 文字数
	 * @return 文字数でカットした文字列
	 */
	public static String checkLength(String value, Integer length){

		//入力文字列の文字列長をチェック
		if(value.length() > length){
			return value.substring(0, length);
		}
		return value;
	}
}

