/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;

/**
 * SNMP監視情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteMonitorSnmp {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteMonitorSnmp.class);

	/**
	 * SNMP監視情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				int monitorType = MonitorTypeConstant.stringToType((String)line.get(3));
				deleteMonitorInfo((String)line.get(0), monitorType);
			}
		}

		log.info(Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * 監視情報を削除する。<br>
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorType 監視種別
	 */
	protected void deleteMonitorInfo(String monitorId, int monitorType) {
		MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();

		try {
			Object[] args = {monitorId};
			log.info(Messages.getMsg("MonitorID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			snmp.deleteSnmp(monitorId, monitorType);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();

		ArrayList records = null;
		try {
			records = snmp.getSnmpList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}