/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.bean.MonitorProcessInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorProcess
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorProcess.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importProcess() {
        log.info((Object)Messages.getMsg("Process.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/PROCESS.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Process.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 7), monitorInfo);
        this.createMonitorBlock(arrayList.subList(7, 8), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(8, 13), monitorInfo);
        this.createMonitorNotify(arrayList.subList(13, 18), monitorInfo);
        this.createMonitorApplication(arrayList.subList(18, 19), monitorInfo);
        this.createMonitorVaild(arrayList.subList(19, 20), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        MonitorProcessInfo monitorProcessInfo = new MonitorProcessInfo();
        String string = CheckString.checkLength(list.get(0), 256);
        if (!string.equals(list.get(0))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"command"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorProcessInfo.setCommand(string);
        objectArray = CheckString.checkLength(list.get(1), 256);
        if (!objectArray.equals(list.get(1))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"param"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        monitorProcessInfo.setParam((String)objectArray);
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorProcessInfo);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorProcessController monitorProcessController = EjbConnectionManager.getConnectionManager().getMonitorProcessController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorProcessController.modifyProcess(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorProcessController.addProcess(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorProcessController monitorProcessController = EjbConnectionManager.getConnectionManager().getMonitorProcessController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorProcessController.getProcessList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

