/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSnmpString
extends ExportMonitorString {
    private static Log log = LogFactory.getLog(ExportMonitorSnmpString.class);

    public void exportSnmp() {
        log.info((Object)Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList3 = this.getSnmpList();
        if (arrayList3 instanceof ArrayList) {
            for (ArrayList arrayList4 : arrayList3) {
                int n = MonitorTypeConstant.stringToType((String)((String)arrayList4.get(3)));
                if (n != 2) continue;
                Object[] objectArray = new Object[]{(String)arrayList4.get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getSnmp((String)arrayList4.get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
                arrayList2.addAll(this.createMonitorJudgement(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new IntegerListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SNMP_STR_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SNMP_STR_RULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorSnmpInfo monitorSnmpInfo = (MonitorSnmpInfo)monitorInfo.getCheckInfo();
        if (monitorSnmpInfo == null) {
            monitorSnmpInfo = new MonitorSnmpInfo();
        }
        if (monitorSnmpInfo.getCommunityName() != null) {
            arrayList.add(monitorSnmpInfo.getCommunityName());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpPort() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpPort().toString());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpOid() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpOid());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpVersion() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpVersion());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getSnmp(String string, int n) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorSnmpController.getSnmp(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getSnmpList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

