/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.TokenPattern;

class TokenStringDFA {
    private State[] ascii = new State[128];
    private State nonAscii = new State();

    TokenStringDFA() {
    }

    public void addMatch(String str, boolean caseInsensitive, TokenPattern value) {
        State state;
        char c = str.charAt(0);
        int start = 0;
        if (caseInsensitive) {
            c = Character.toLowerCase(c);
        }
        if (c < '\u0080') {
            state = this.ascii[c];
            if (state == null) {
                state = this.ascii[c] = new State();
            }
            ++start;
        } else {
            state = this.nonAscii;
        }
        for (int i = start; i < str.length(); ++i) {
            State next = state.tree.find(str.charAt(i), caseInsensitive);
            if (next == null) {
                next = new State();
                state.tree.add(str.charAt(i), caseInsensitive, next);
            }
            state = next;
        }
        state.value = value;
    }

    public TokenPattern match(ReaderBuffer buffer, boolean caseInsensitive) throws IOException {
        State state;
        TokenPattern result = null;
        int pos = 0;
        int c = buffer.peek(0);
        if (c < 0) {
            return null;
        }
        if (caseInsensitive) {
            c = Character.toLowerCase(c);
        }
        if (c < 128) {
            state = this.ascii[c];
            if (state == null) {
                return null;
            }
            if (state.value != null) {
                result = state.value;
            }
            ++pos;
        } else {
            state = this.nonAscii;
        }
        while ((c = buffer.peek(pos)) >= 0 && (state = state.tree.find((char)c, caseInsensitive)) != null) {
            if (state.value != null) {
                result = state.value;
            }
            ++pos;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.ascii.length; ++i) {
            if (this.ascii[i] == null) continue;
            buffer.append((char)i);
            if (this.ascii[i].value != null) {
                buffer.append(": ");
                buffer.append(this.ascii[i].value);
                buffer.append("\n");
            }
            this.ascii[i].tree.printTo(buffer, " ");
        }
        this.nonAscii.tree.printTo(buffer, "");
        return buffer.toString();
    }

    class TransitionTree {
        private char value = '\u0000';
        private State state = null;
        private TransitionTree left = null;
        private TransitionTree right = null;

        TransitionTree() {
        }

        public State find(char c, boolean lowerCase) {
            if (lowerCase) {
                c = Character.toLowerCase(c);
            }
            if (this.value == '\u0000' || this.value == c) {
                return this.state;
            }
            if (this.value > c) {
                return this.left.find(c, false);
            }
            return this.right.find(c, false);
        }

        public void add(char c, boolean lowerCase, State state) {
            if (lowerCase) {
                c = Character.toLowerCase(c);
            }
            if (this.value == '\u0000') {
                this.value = c;
                this.state = state;
                this.left = new TransitionTree();
                this.right = new TransitionTree();
            } else if (this.value > c) {
                this.left.add(c, false, state);
            } else {
                this.right.add(c, false, state);
            }
        }

        public void printTo(StringBuffer buffer, String indent) {
            if (this.left != null) {
                this.left.printTo(buffer, indent);
            }
            if (this.value != '\u0000') {
                if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
                    buffer.append(indent);
                }
                buffer.append(this.value);
                if (this.state.value != null) {
                    buffer.append(": ");
                    buffer.append(this.state.value);
                    buffer.append("\n");
                }
                this.state.tree.printTo(buffer, indent + " ");
            }
            if (this.right != null) {
                this.right.printTo(buffer, indent);
            }
        }
    }

    class State {
        protected TokenPattern value = null;
        protected TransitionTree tree = new TransitionTree();

        State() {
        }
    }
}

