/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;

public abstract class Node {
    private Node parent = null;
    private ArrayList values = null;

    boolean isHidden() {
        return false;
    }

    public abstract int getId();

    public abstract String getName();

    public int getStartLine() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int line = this.getChildAt(i).getStartLine();
            if (line < 0) continue;
            return line;
        }
        return -1;
    }

    public int getStartColumn() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int col = this.getChildAt(i).getStartColumn();
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    public int getEndLine() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            int line = this.getChildAt(i).getEndLine();
            if (line < 0) continue;
            return line;
        }
        return -1;
    }

    public int getEndColumn() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            int col = this.getChildAt(i).getEndColumn();
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    public Node getParent() {
        return this.parent;
    }

    void setParent(Node parent) {
        this.parent = parent;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getChildAt(int index) {
        return null;
    }

    public int getDescendantCount() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            count += 1 + this.getChildAt(i).getDescendantCount();
        }
        return count;
    }

    public int getValueCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    public Object getValue(int pos) {
        if (this.values == null || pos < 0 || pos >= this.values.size()) {
            return null;
        }
        return this.values.get(pos);
    }

    public ArrayList getAllValues() {
        return this.values;
    }

    public void addValue(Object value) {
        if (value != null) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
        }
    }

    public void addValues(Vector values) {
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this.addValue(values.get(i));
            }
        }
    }

    public void addValues(ArrayList values) {
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                this.addValue(values.get(i));
            }
        }
    }

    public void removeAllValues() {
        this.values = null;
    }

    public void printTo(PrintStream output) {
        this.printTo(new PrintWriter(output));
    }

    public void printTo(PrintWriter output) {
        this.printTo(output, "");
        output.flush();
    }

    private void printTo(PrintWriter output, String indent) {
        output.println(indent + this.toString());
        indent = indent + "  ";
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).printTo(output, indent);
        }
    }
}

