/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSnmp
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorSnmp.class);

    public ExportMonitorSnmp() {
        super(1);
    }

    public void exportSnmp() {
        log.info((Object)Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getSnmpList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                int n = MonitorTypeConstant.stringToType((String)((String)((ArrayList)cloneable).get(3)));
                if (n != 1) continue;
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getSnmp((String)((ArrayList)cloneable).get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SNMP" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorSnmpInfo monitorSnmpInfo = (MonitorSnmpInfo)monitorInfo.getCheckInfo();
        if (monitorSnmpInfo == null) {
            monitorSnmpInfo = new MonitorSnmpInfo();
        }
        if (monitorSnmpInfo.getCommunityName() != null) {
            arrayList.add(monitorSnmpInfo.getCommunityName());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpPort() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpPort().toString());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpOid() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpOid());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getSnmpVersion() != null) {
            arrayList.add(monitorSnmpInfo.getSnmpVersion());
        } else {
            arrayList.add("");
        }
        if (monitorSnmpInfo.getConvertFlg() != null) {
            arrayList.add(ConvertValueConstant.typeToString((int)monitorSnmpInfo.getConvertFlg()));
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getSnmp(String string, int n) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorSnmpController.getSnmp(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getSnmpList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

