/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.util;

import com.clustercontrol.accesscontrol.ejb.session.AccessCheck;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheckHome;
import com.clustercontrol.util.Messages;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;

public class LoginManager {
    private static LoginManager m_instance = null;
    private NamingContext m_namingcontext = null;
    private LoginContext m_loginContext = null;
    private String m_url = null;
    private String m_uid = null;
    private String m_password = null;
    private static Log log = LogFactory.getLog(LoginManager.class);

    public static LoginManager getContextManager() {
        if (m_instance == null) {
            m_instance = new LoginManager();
        }
        return m_instance;
    }

    private LoginManager() {
        try {
            Configuration.setConfiguration(new HinemosClientConfig());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void login(String string, String string2, String string3) throws Exception {
        this.logout();
        this.m_uid = string;
        this.m_password = string2;
        this.m_namingcontext = this.getContext(string3);
        try {
            AccessCheckHome accessCheckHome = (AccessCheckHome)this.m_namingcontext.lookup("AccessCheck");
            AccessCheck accessCheck = accessCheckHome.create();
            accessCheck.checkLogin();
        }
        catch (Exception exception) {
            this.logout();
            throw exception;
        }
    }

    public synchronized void logout() throws NamingException {
        if (this.m_loginContext instanceof LoginContext) {
            try {
                this.m_loginContext.logout();
                this.m_uid = null;
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        this.m_loginContext = null;
        this.m_namingcontext = null;
    }

    public boolean isLogin() {
        return this.m_loginContext instanceof LoginContext;
    }

    public synchronized NamingContext getNamingContext(String string, String string2, String string3) throws NamingException {
        if (!this.isLogin()) {
            try {
                this.login(string, string2, string3);
            }
            catch (CommunicationException communicationException) {
                log.error((Object)Messages.getString((String)"message.accesscontrol.22"), (Throwable)communicationException);
            }
            catch (AccessException accessException) {
                log.error((Object)Messages.getString((String)"message.accesscontrol.6"), (Throwable)accessException);
            }
            catch (Exception exception) {
                log.error((Object)Messages.getString((String)"message.accesscontrol.23"), (Throwable)exception);
                log.error((Object)Messages.getString((String)"message.accesscontrol.6"));
            }
        }
        return this.m_namingcontext;
    }

    private NamingContext getContext(String string) throws NamingException, LoginException {
        this.m_url = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.provider.url", this.m_url);
        UsernamePasswordHandler usernamePasswordHandler = new UsernamePasswordHandler(this.m_uid, this.m_password.toCharArray());
        this.m_loginContext = new LoginContext("hinemosClient", (CallbackHandler)usernamePasswordHandler);
        this.m_loginContext.login();
        NamingContextFactory namingContextFactory = new NamingContextFactory();
        NamingContext namingContext = (NamingContext)namingContextFactory.getInitialContext(hashtable);
        return namingContext;
    }

    public String getUserId() {
        return this.m_uid;
    }

    class HinemosClientConfig
    extends Configuration {
        HinemosClientConfig() {
        }

        public void refresh() {
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
            AppConfigurationEntry[] appConfigurationEntryArray = null;
            try {
                Class[] classArray = new Class[]{};
                Method method = this.getClass().getDeclaredMethod(string, classArray);
                Object[] objectArray = new Object[]{};
                appConfigurationEntryArray = (AppConfigurationEntry[])method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return appConfigurationEntryArray;
        }

        AppConfigurationEntry[] hinemosClient() {
            String string = "org.jboss.security.ClientLoginModule";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("multi-threaded", "true");
            hashMap.put("restore-login-identity", "true");
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(string, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashMap);
            AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[]{appConfigurationEntry};
            return appConfigurationEntryArray;
        }
    }
}

