/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSnmp
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorSnmp.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSnmp() {
        log.info((Object)Messages.getMsg("Snmp.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SNMP.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Snmp.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorBlock(arrayList.subList(10, 11), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(11, 16), monitorInfo);
        this.createMonitorNotify(arrayList.subList(16, 22), monitorInfo);
        this.createMonitorApplication(arrayList.subList(22, 23), monitorInfo);
        this.createMonitorVaild(arrayList.subList(23, 24), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object object;
        SnmpCheckInfo snmpCheckInfo = new SnmpCheckInfo();
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"community.name"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        snmpCheckInfo.setCommunityName(string);
        snmpCheckInfo.setSnmpPort(Integer.valueOf(Integer.parseInt(list.get(1))));
        object = CheckString.checkLength(list.get(2), 1024);
        if (!((String)object).equals(list.get(2))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"oid"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        snmpCheckInfo.setSnmpOid((String)object);
        snmpCheckInfo.setSnmpVersion(list.get(3));
        snmpCheckInfo.setConvertFlg(Integer.valueOf(ConvertValueConstant.stringToType((String)list.get(4))));
        monitorInfo.setSnmpCheckInfo(snmpCheckInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSnmpController.modifySnmp(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSnmpController.addSnmp(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

