/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.logtransfer;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import jp.co.intellilink.hinemos.util.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLogTransfer {
    private static Log log = LogFactory.getLog(ImportLogTransfer.class);
    private ArrayList logTransferList = null;
    private ArrayList<ArrayList<String>> logTransferInfos = null;

    public void importLogTransfer() {
        log.info((Object)Messages.getMsg("LogTransfer.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.logTransferInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/LOGTRANSFER.csv");
        this.logTransferList = this.getLogTransferList();
        for (ArrayList<String> arrayList : this.logTransferInfos) {
            LogTransferInfo logTransferInfo = this.createMaintenanceInfo(arrayList);
            this.registerLogTransferInfo(logTransferInfo);
        }
        log.info((Object)Messages.getMsg("LogTransfer.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public LogTransferInfo createMaintenanceInfo(ArrayList<String> arrayList) {
        Object[] objectArray;
        Object[] objectArray2;
        LogTransferInfo logTransferInfo = new LogTransferInfo();
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"logtransfer.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        logTransferInfo.setTransferId(string);
        objectArray2 = CheckString.checkLength(arrayList.get(1), 256);
        if (!objectArray2.equals(arrayList.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        logTransferInfo.setDescription(arrayList.get(1));
        logTransferInfo.setFacilityId(arrayList.get(2));
        if (!RepositoryUtil.findFacilityId(arrayList.get(2))) {
            objectArray = new String[]{logTransferInfo.getTransferId(), arrayList.get(2)};
            log.error((Object)Messages.getMsg("ImportTool.Repository.1", objectArray));
            System.exit(20);
        }
        objectArray = new ArrayList();
        LogTransferFileInfo logTransferFileInfo = new LogTransferFileInfo();
        String string2 = CheckString.checkLength(arrayList.get(3), 4096);
        if (!string2.equals(arrayList.get(3))) {
            Object[] objectArray3 = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "4096"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray3));
        }
        logTransferFileInfo.setFilePath(string2);
        logTransferFileInfo.setRunInterval(Integer.parseInt(arrayList.get(4)));
        logTransferFileInfo.setExistenceFlg(YesNoConstant.stringToType((String)arrayList.get(5)));
        logTransferFileInfo.setValid(ValidConstant.stringToType((String)arrayList.get(6)));
        objectArray.add(logTransferFileInfo);
        logTransferInfo.setFileInfo((ArrayList)objectArray);
        logTransferInfo.setValid(ValidConstant.stringToType((String)arrayList.get(7)));
        return logTransferInfo;
    }

    protected ArrayList checkLogTransferList(String string) {
        if (this.logTransferList instanceof ArrayList) {
            for (ArrayList arrayList : this.logTransferList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected void registerLogTransferInfo(LogTransferInfo logTransferInfo) {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        try {
            ArrayList arrayList = this.checkLogTransferList(logTransferInfo.getTransferId());
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(5);
                String string = (String)arrayList.get(4);
                logTransferInfo.setRegDate(new Timestamp(date.getTime()));
                logTransferInfo.setRegUser(string);
                Object[] objectArray = new Object[]{logTransferInfo.getTransferId()};
                log.info((Object)(Messages.getMsg("TransferID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                logTransferController.modifyLogTransfer(logTransferInfo);
            } else {
                Object[] objectArray = new Object[]{logTransferInfo.getTransferId()};
                log.info((Object)(Messages.getMsg("TransferID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                logTransferController.addLogTransfer(logTransferInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{logTransferInfo.getTransferId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getLogTransferList() {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        ArrayList arrayList = null;
        try {
            arrayList = logTransferController.getLogTransferList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

