/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.job;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.JobUtil;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSchedule {
    private static Log log = LogFactory.getLog(ImportSchedule.class);
    private ArrayList<ArrayList<String>> scheduleInfo = null;
    private ArrayList scheduleList = null;
    private JobTreeItem jobTreeItem = null;

    public void importSchedule() {
        log.info((Object)Messages.getMsg("Job.Schedule.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.scheduleInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB_SCHEDULE.csv");
        this.jobTreeItem = this.getJobTree();
        this.scheduleList = this.getScheduleList();
        for (ArrayList<String> arrayList : this.scheduleInfo) {
            JobSchedule jobSchedule = this.createScheduleInfo(arrayList);
            this.registerSchedule(jobSchedule);
        }
        log.info((Object)Messages.getMsg("Job.Schedule.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public JobSchedule createScheduleInfo(ArrayList<String> arrayList) {
        String[] stringArray;
        Object[] objectArray;
        JobSchedule jobSchedule = new JobSchedule();
        String string = CheckString.checkLength(arrayList.get(0), 80);
        if (!string.equals(arrayList.get(0))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"schedule.id"), "80"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            System.exit(20);
        }
        jobSchedule.setId(string);
        objectArray = CheckString.checkLength(arrayList.get(1), 120);
        if (!objectArray.equals(arrayList.get(1))) {
            stringArray = new String[]{com.clustercontrol.util.Messages.getString((String)"schedule.name"), "120"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", stringArray));
        }
        jobSchedule.setName((String)objectArray);
        jobSchedule.setJobunitId(arrayList.get(2));
        if (!JobUtil.findJobUnitId(jobSchedule.getJobunitId(), this.jobTreeItem)) {
            stringArray = new String[]{jobSchedule.getId(), jobSchedule.getJobId()};
            log.error((Object)Messages.getMsg("ImportTool.Job.6", stringArray));
            System.exit(20);
        }
        jobSchedule.setJobId(arrayList.get(3));
        if (!JobUtil.findJobId(jobSchedule.getJobId(), this.jobTreeItem)) {
            stringArray = new String[]{jobSchedule.getId(), jobSchedule.getJobId()};
            log.error((Object)Messages.getMsg("ImportTool.Job.5", stringArray));
            System.exit(20);
        }
        jobSchedule.setJobName(arrayList.get(4));
        jobSchedule.setCalendarId(arrayList.get(5));
        stringArray = new Schedule();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        if (arrayList.get(6).compareTo(com.clustercontrol.util.Messages.getString((String)"time")) == 0) {
            if (arrayList.get(7).length() > 0) {
                n = Integer.parseInt(arrayList.get(7));
            }
            if (arrayList.get(8).length() > 0) {
                n2 = Integer.parseInt(arrayList.get(8));
            }
            if (arrayList.get(9).length() > 0) {
                n3 = Integer.parseInt(arrayList.get(9));
            }
            if (arrayList.get(10).length() > 0) {
                n4 = Integer.parseInt(arrayList.get(10));
            }
            if (arrayList.get(7).length() == 0 && arrayList.get(8).length() == 0 && arrayList.get(9).length() == 0) {
                stringArray.setType(3);
            } else if (arrayList.get(7).length() == 0 && arrayList.get(8).length() == 0) {
                stringArray.setType(2);
            } else if (arrayList.get(7).length() == 0) {
                stringArray.setType(1);
            } else {
                stringArray.setType(0);
            }
            if (!(n instanceof Integer) && stringArray.getType() == 0) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.26"));
                return null;
            }
            if (!(n2 instanceof Integer || stringArray.getType() != 0 && stringArray.getType() != 1)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.27"));
                return null;
            }
            if (!(n3 instanceof Integer || stringArray.getType() != 0 && stringArray.getType() != 1 && stringArray.getType() != 2)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        } else {
            stringArray.setType(4);
            if (arrayList.get(11).length() > 0) {
                n5 = new Integer(DayOfWeekConstant.stringToType((String)arrayList.get(11)));
            }
            if (arrayList.get(12).length() > 0) {
                n3 = Integer.parseInt(arrayList.get(12));
            }
            if (arrayList.get(13).length() > 0) {
                n4 = Integer.parseInt(arrayList.get(13));
            }
            if (!(n5 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.37"));
                return null;
            }
            if (!(n3 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        if (n instanceof Integer) {
            calendar.set(2, n - 1);
        }
        if (n2 instanceof Integer) {
            calendar.set(5, n2);
        }
        if (n3 instanceof Integer) {
            calendar.set(11, n3);
        }
        if (n5 instanceof Integer) {
            calendar.set(7, n5);
            stringArray.setDayOfWeek(n5.intValue());
        }
        calendar.set(12, n4);
        calendar.set(13, 0);
        stringArray.setDate(calendar.getTime());
        jobSchedule.setSchedule((Schedule)stringArray);
        jobSchedule.setValid(ValidConstant.stringToType((String)arrayList.get(14)));
        return jobSchedule;
    }

    protected void registerSchedule(JobSchedule jobSchedule) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        try {
            JobSchedule jobSchedule2 = this.checkScheduleList(jobSchedule.getId());
            if (jobSchedule2 instanceof JobSchedule) {
                jobSchedule.setCreateTime(jobSchedule2.getCreateTime());
                jobSchedule.setCreateUser(jobSchedule2.getCreateUser());
                Object[] objectArray = new Object[]{jobSchedule.getId()};
                log.info((Object)(Messages.getMsg("ScheduleID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                jobController.modifySchedule(jobSchedule);
            } else {
                Object[] objectArray = new Object[]{jobSchedule.getId()};
                log.info((Object)(Messages.getMsg("ScheduleID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                jobController.addSchedule(jobSchedule);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected JobSchedule checkScheduleList(String string) {
        if (this.scheduleList instanceof ArrayList) {
            for (JobSchedule jobSchedule : this.scheduleList) {
                if (jobSchedule.getId().compareTo(string) != 0) continue;
                return jobSchedule;
            }
        }
        return null;
    }

    protected ArrayList getScheduleList() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getScheduleList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(false, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

