/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.notify;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMailTemplate {
    private static Log log = LogFactory.getLog(ImportMailTemplate.class);
    private ArrayList mailTemplateList = null;
    private ArrayList<ArrayList<String>> mailTemplateInfos = null;

    public void importMailTemplate() {
        log.info((Object)Messages.getMsg("MailTemplate.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.mailTemplateInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/MAILTEMPLATE.csv");
        this.mailTemplateList = this.getMailTemplateList();
        for (ArrayList<String> arrayList : this.mailTemplateInfos) {
            MailTemplateInfoData mailTemplateInfoData = this.createMailTemplateInfo(arrayList);
            this.registerMailTemplateInfo(mailTemplateInfoData);
        }
        log.info((Object)Messages.getMsg("MailTemplate.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public MailTemplateInfoData createMailTemplateInfo(ArrayList<String> arrayList) {
        Object[] objectArray;
        Object[] objectArray2;
        MailTemplateInfoData mailTemplateInfoData = new MailTemplateInfoData();
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"mail.template.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        mailTemplateInfoData.setMailTemplateId(string);
        objectArray2 = CheckString.checkLength(arrayList.get(1), 256);
        if (!objectArray2.equals(arrayList.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        mailTemplateInfoData.setDescription((String)objectArray2);
        objectArray = CheckString.checkLength(arrayList.get(2), 256);
        if (!objectArray.equals(arrayList.get(2))) {
            Object[] objectArray3 = new String[]{com.clustercontrol.util.Messages.getString((String)"subject"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray3));
        }
        mailTemplateInfoData.setSubject((String)objectArray);
        mailTemplateInfoData.setBody(arrayList.get(3));
        return mailTemplateInfoData;
    }

    protected ArrayList checkMailTemplateList(String string) {
        if (this.mailTemplateList instanceof ArrayList) {
            for (ArrayList arrayList : this.mailTemplateList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected void registerMailTemplateInfo(MailTemplateInfoData mailTemplateInfoData) {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        try {
            ArrayList arrayList = this.checkMailTemplateList(mailTemplateInfoData.getMailTemplateId());
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(3);
                String string = (String)arrayList.get(2);
                mailTemplateInfoData.setRegDate(new Timestamp(date.getTime()));
                mailTemplateInfoData.setRegUser(string);
                Object[] objectArray = new Object[]{mailTemplateInfoData.getMailTemplateId()};
                log.info((Object)(Messages.getMsg("MailTemplateID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                mailTemplateController.modifyMailTemplate(mailTemplateInfoData);
            } else {
                Object[] objectArray = new Object[]{mailTemplateInfoData.getMailTemplateId()};
                log.info((Object)(Messages.getMsg("MailTemplateID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                mailTemplateController.addMailTemplate(mailTemplateInfoData);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{mailTemplateInfoData.getMailTemplateId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMailTemplateList() {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        ArrayList arrayList = null;
        try {
            arrayList = mailTemplateController.getMailTemplateList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

