package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;

import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author iwasaki
 */
public abstract class AbstractRuntimeSpectrogramView extends AbstractRuntimeBean {

	private String name_ = null;
	private double minValue_ = -1;
	private double maxValue_ = 1;
	private double frequency_ = 100;
	

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		try {
			String fname=(String) context.getObjectFromRepogitory(BlockDiagramExecutor.KEY_BLOCK_DIAGRAM_FILE_NAME);
			if (fname==null) fname="";
			IWorkbenchWindow window=(IWorkbenchWindow) context.getObjectFromRepogitory(IWorkbenchWindow.class);
			setupView(window, fname + (name_!=null ? (" - "+name_) : ""));
		} catch (Exception ex) {
			CoreUtil.throwAsRuntimeException(ex);
		}
	}
	
	protected abstract void setupView(IWorkbenchWindow window, String keyName) throws Exception;

	public String getName() {
		return name_;
	}

	public void setName(String name) {
		name_ = name;
	}

	public double getMinValue() {
		return minValue_;
	}

	public void setMinValue(double valueMin) {
		minValue_ = valueMin;
	}

	public double getMaxValue() {
		return maxValue_;
	}

	public void setMaxValue(double valueMax) {
		maxValue_ = valueMax;
	}

	public double getFrequency() {
		return frequency_;
	}

	public void setFrequency(double frequency) {
		frequency_ = frequency;
	}

}
