package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 入力された文字列の中で、srcStringプロパティで指定された文字列を、destStringプロパティで指定された文字列に置換して、出力します。
 * 入力：文字列系列
 * 出力：文字列系列
 * @author iwasaki
 */
public class StringReplacer extends AbstractFilter {
	private String srcString_;
	private String srcRegex_;
	private String destString_;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s=(String)message;
			if (srcString_!=null) {
				outputMessage(s.replace(srcString_, destString_));
			}else if (srcRegex_!=null) {
				outputMessage(s.replaceAll(srcRegex_, destString_));
			}else{
				outputMessage(s);
			}
		}else{
			outputMessage(message);
		}
	}

	/**
	 * 置換元の文字列を指定します。
	 */
	public void setSrcString(String srcString) {
		srcString_ = srcString;
	}

	/**
	 * 置換先の文字列を指定します。
	 */
	public void setDestString(String destString) {
		destString_ = destString;
	}

	/**
	 * 置換元の文字列を正規表現で指定します。（srcStringがnullの場合のみ有効）
	 */
	public void setSrcRegex(String srcStringAsRegexp) {
		srcRegex_ = srcStringAsRegexp;
	}

}
