package jp.hasc.hasctool.core.runtime.hierarchize;

import java.util.regex.Pattern;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 文字列系列の中で、正規表現を満たした文字列のみを出力するフィルタです。
 * @author iwasaki
 */
public class RegexStringFilter extends AbstractFilter {
	private String regex_;
	private Pattern regexPat_;
	private boolean not_=false;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message==EnumCommand.BEGIN) {
			regexPat_=Pattern.compile(regex_);
			outputMessage(message);
		}else if (message instanceof String) {
			String s=(String)message;
			if (regexPat_.matcher(s).find()) {
				if (!not_) outputMessage(message);
			}else{
				if (not_) outputMessage(message);
			}
		}else{
			outputMessage(message);
		}
	}

	/**
	 * 正規表現を指定します
	 */
	public void setRegex(String regex) {
		regex_ = regex;
	}

	/**
	 * trueなら、正規表現を「満たさないもの」を出力します。
	 */
	public void setNot(boolean not) {
		not_ = not;
	}
}
