package jp.hasc.hasctool.core.runtime.hierarchize;

import java.util.ArrayList;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;

/**
 * フォルダ内のファイル一覧を、文字列系列として出力するブロックです。
 * @author iwasaki
 */
public class FolderFileFinder extends AbstractSource {
	private boolean recursive_=true;
	private String folderPath_=null;
	
	/**
	 * フォルダを再帰的に探索するかどうかを指定します。
	 */
	public void setRecursive(boolean recursive) {
		recursive_ = recursive;
	}
	
	/**
	 * フォルダのパスを指定します。
	 */
	public void setFolderPath(String folderPath) {
		folderPath_ = folderPath;
	}

	@Override
	protected void run() throws InterruptedException {
		outputMessage(EnumCommand.BEGIN);
		try{
			findFile(folderPath_);
		}finally{
			outputMessage(EnumCommand.END);
		}
	}
	
	public void findFile(String folderPath) throws InterruptedException {
		FileStreamProvider fsp = getRuntimeContext().getFileStreamProvider();
		ArrayList<String> out=new ArrayList<String>();
		fsp.listFileNames(folderPath, out);
		for(String cname: out) {
			String cpath=folderPath+"/"+cname;
			outputMessage(cpath);
		}
		if (recursive_) {
			out.clear();
			fsp.listSubFolderNames(folderPath, out);
			for(String cname: out) {
				String cpath=folderPath+"/"+cname;
				findFile(cpath);
			}
		}
	}
}
