package jp.hasc.hasctool.core.runtime.filter.tick;

import java.util.ArrayList;
import java.util.Iterator;

import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * フィルタから何も出力されない時に、n回SignalMessageを入力するごとにNullSignalMessageを出力する、TickEmitterです。
 * フィルタが、n回前に入力したSignalMessageの時刻以降の時刻を持ったSignalMessageしか出力しない場合に、利用できます。
 * 具体的には、(2*n)回前に入力したSignalMessageの時刻以降の時刻を持ったSignalMessageが出力されていなければ、
 * n回前に入力したSignalMessageの時刻を持ったNullSignalMessageを出力します。
 * @author iwasaki
 */
public class SampleBasedTickEmitter extends TickEmitter {
	private int n;
	private ArrayList<SignalMessage> signals_=null;
	
	public SampleBasedTickEmitter(int n) {
		super();
		this.n = n;
	}
	
	private int getM() {
		return n*2;
	}
	
	private void ensureSignals() {
		if (signals_==null) signals_=new ArrayList<SignalMessage>();
	}
	
	@Override
	public void afterProcessSignalMessage(SignalMessage sig) throws InterruptedException {
		ensureSignals();
		signals_.add(sig);
		int size=signals_.size();
		if (size>=getM()) {
			outputTickMessage(signals_.get(size-n).getTime());
		}
	}
	
	@Override
	public void onOutputSignalMessage(SignalMessage sig) {
		ensureSignals();
		for(Iterator<SignalMessage> it=signals_.iterator();it.hasNext();) {
			SignalMessage be = it.next();
			if (be.getTime()<=sig.getTime()) it.remove(); else break;
		}
	}
}
