package jp.hasc.hasctool.core.runtime.filter.interpolator;

import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * 付近の信号値から、特定時刻の信号値を補間します
 * @author iwasaki
 */
public interface SignalInterpolator {
	/**
	 * 信号のサンプル値を順番に追加します
	 * @return 要素を処理したらtrue、無視したらfalseを返します
	 */
	public boolean addSample(SignalMessage message);
	
	/**
	 * 特定時刻の信号値を補間して返します。
	 * このメソッドが呼ばれる前に、時間的に直後（同時刻を含む）にある要素までが、addSample()で追加されます。
	 */
	public SignalMessage getAtTime(long time);
}
