package jp.hasc.hasctool.core.runtime.filter.file.table;

import java.util.HashMap;
import java.util.Iterator;

import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * テーブルを対象としたカウントクラス
 * 指定した情報を含むファイル数をカウント
 * 複数の情報を指定可（ただし","で区切ること！）
 * @author hiro
 */

public class InformationCounter extends TableCounter{

	boolean start_ = true;
	HashMap<String, Integer> hmap_;
	String inf_;
	String[] infArray_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		hmap_ = new HashMap<String, Integer>();
		infArray_ = inf_.split(",");
		for(int i = 0; i<infArray_.length; i++){
			hmap_.put(infArray_[i], 0);
		}
	}

	@Override
	void count(String line) {
		if(start_){
			start_ = false;
		} else{
			for(int i = 0; i<infArray_.length; i++){
				if (0 <= line.indexOf(infArray_[i])){
					String key = infArray_[i];
					int count  = hmap_.get(key);
					count++;
					hmap_.put(key, count);
				}
			}
		}
	}

	@Override
	String getResult() {
		String crlf = System.getProperty("line.separator");
		Iterator<String> it = hmap_.keySet().iterator();
		String row = "";
		while (it.hasNext()) {
			String key = (String) it.next();
			int count =  hmap_.get(key);
			row += key + "," + count;
			row += crlf;
		}
		return row;
	}

	public void setInformation(String inf){
		inf_ = inf;
	}
}
