package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * 指定した項目を使ったテーブルの編集
 * 複数の項目を指定可（ただし","で区切ること！）
 * @author hiro
 */

public class ElementEffector extends TableEffector{

	boolean start_ = true;
	String element_;
	String[] elementArray_;
	int[] index_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		elementArray_ = element_.split(",");
		index_ = new int[elementArray_.length];
	}

	String getResult(String line){
		String row = "";
		String[] val = line.split(",");
		if(start_){
			for(int i = 0; i<elementArray_.length; i++){
				for(int j = 0; j<val.length; j++){
					if(val[j].equals(elementArray_[i])){
						index_[i] = j;
					}
				}
			}
			start_ = false;
		}
		for(int i=0; i<index_.length; i++){
			if(i != 0)row += ",";
			row += val[index_[i]];
		}
		return row;
	}

	public void setElement(String element){
		element_ = element;
	}
}
