package jp.hasc.hasctool.core.runtime.filter.file.path;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * person情報によりフィルタリングを行います
 * @author hiro
 */

public class FilePersonFilter extends AbstractFilter{

	private String person_;
	private int[][] personList_;
	private boolean not_ = false;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		this.start();
	}

	private void start(){
		String[] pList;
		if (0 <= person_.indexOf(",")){
			pList = person_.split(",");
		} else {
			pList = new String[1];
			pList[0] = person_;
		}
		int plen = pList.length;
		personList_ = new int[plen][2];
		for(int i=0; i<plen; i++){
			if (0 <= pList[i].indexOf("-")){
				String[] row = pList[i].split("-");
				personList_[i][0] = Integer.parseInt(row[0]);
				personList_[i][1] = Integer.parseInt(row[1]);
			} else {
				personList_[i][0] = Integer.parseInt(pList[i]);
				personList_[i][1] = personList_[i][0];
			}
		}
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String filePath =(String)message;
			boolean find = false;
			for(int i=0; i<personList_.length; i++){
				for(int j=personList_[i][0]; j<=personList_[i][1]; j++){
					if (0 <= filePath.indexOf("person"+j)){
						find = true;
						if(!(not_)){
							outputMessage(filePath);
						}
						break;
					}
				}
				if(find)break;
			}
			if(!(find)){
				if(not_){
					outputMessage(filePath);
				}
			}
		
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setPersonNo(String pnum){
		person_ = pnum;
	}

	public void setNot(boolean not){
		not_ = not;
	}
}
