package jp.hasc.hasctool.core.runtime.filter.file.path;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 指定した階層について１つのディレクトリでまとめるためのフィルタです
 * @author hiro
 */
public class DirectoryMerger extends AbstractFilter{

	private int folderClass_ = 4; //csvからentryまでの階層数
	private String feature_;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}
	
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] part = s.split("/");
			String dname = part[part.length - folderClass_];
			outputMessage(s.replace(dname, feature_));
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setFeature(String feature){
		feature_ = feature;
	}
	
	public void setFolderClass(int folderClass){
		folderClass_ = folderClass+1;
	}
}
