package jp.hasc.hasctool.core.runtime.filter.file.label;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;

/**
 * 入力されたLabelSignalMessage系列に、ヘッダコメント #targetFile: が見つかった場合、指定されたファイルを読み込んで、文字列系列として出力します。
 * @author iwasaki
 */
public class TargetFileReader extends AbstractFilter {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(TargetFileReader.class);
	
	private LineReaderSource reader_=null;
	
	private boolean startReader_=true;
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String str=(String)message;
			if (str.startsWith(LabelInfo.HEADER_PREFIX_TARGET_FILE)) {
				if (reader_!=null) throw new RuntimeException("duplicate "+LabelInfo.HEADER_PREFIX_TARGET_FILE);        
				String fpath=str.substring(LabelInfo.HEADER_PREFIX_TARGET_FILE.length());
				reader_=new LineReaderSource();
				reader_.setFilePath(fpath);
				reader_.setup(getRuntimeContext());
				reader_.getOutputPort().connect(getInputPortToOutputMessage());
				if (startReader_) {
					reader_.start();
				}
			}
		}else if (message==EnumCommand.END) {
			if (reader_==null) {
				LOG.warn("No "+LabelInfo.HEADER_PREFIX_TARGET_FILE+" header in input");
				// 空の出力
				outputMessage(EnumCommand.BEGIN);
				outputMessage(EnumCommand.END);
			}
		}
	}

	public LineReaderSource getReader() {
		return reader_;
	}

	public boolean isStartReader() {
		return startReader_;
	}

	public void setStartReader(boolean notStartReader) {
		startReader_ = notStartReader;
	}

}
