package jp.hasc.hasctool.core.runtime.filter.file.label;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * LabelFileUpdater
 * labelFileのtargetfileの更新を行います
 * @author hiro
 */

public class LabelFileUpdater extends AbstractFilter{

	private boolean start_ = true;
	private String filePath_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line =(String)message;
			if(start_){
				line = "#targetfile:" + filePath_;
				start_ = false;
			}
			outputMessage(line);
		} else {
			//BEGIN message
			outputMessage(message);
		}
	}

	public void setFilePath(String fpath) {
		filePath_ = fpath;
	}
}
