package jp.hasc.hasctool.core.runtime.filter.evaluation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CoreUtil;

/**
 *　評価結果ファイルをまとめます
 * @author hiro
 */

public class EvaluationListCreator extends AbstractFilter{

	String element_;
	int eLength_;

	public void setElement(String num) {
		element_= num;
	}

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		String[] erow = element_.split(",");
		eLength_ = erow.length;
	}

	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String filePath =(String)message;
			int count = 0;
			boolean start = true;
			String result = filePath;
			try{
				InputStream inps = getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
				while(true){
					String line = bufferedReader.readLine();
					if (count> eLength_) {
						break;
					} else {
						if(start){
							start = false;
							
						//OverAllの時
						} else if(count == eLength_){
							String[] row = line.split(",");
							result += "," + row[1];
							count++;
							
						} else {
							String[] row = line.split(",");
							result += "," + row[count+1];
							count++;
						}
					}
				}
				bufferedReader.close();
				inps.close();
				outputMessage(result);

			} catch (IOException ex) {
				CoreUtil.throwAsRuntimeException(ex);
			} catch (RuntimeException ex) {
			}
		
		} else if (message == EnumCommand.BEGIN) {
			outputMessage(EnumCommand.BEGIN);
			outputMessage("filePath,"+element_+",Overall");
		
		} else if (message == EnumCommand.END) {
			outputMessage(message);
			
		} else {
			// その他のメッセージはそのまま出力
			outputMessage(message);
		}
	}
}
