package jp.hasc.hasctool.core.runtime.filter.evaluation;

public class EvaluationData {

	String[] element_;
	double[][] data_;

	public EvaluationData(String element){
		setup(element.split(","));
	}

	void setup(String[] elementArray){
		int len = elementArray.length;
		data_ = new double[len][len];
		element_ = new String[len];
		for(int i=0; i<len; i++){
			element_[i] = elementArray[i];
		}
	}

	public void setData(double val, int x, int y){
		data_[x][y] += val;
	}

	public int getElementNum(){
		return element_.length;
	}

	public String getElement(int index){
		return element_[index];
	}

	public String[][] getData(){
		return createTable();
	}

	public void div(double time, int index){
		int len = data_[0].length;
		for(int i = 0; i<len; i++){
			for(int j = 0; j<len; j++){
				if(i == index){
					data_[i][j] /= time;
				}
			}
		}
	}

	public double getOverAll(){
		double sum =0.0;
		int len = data_[0].length;
		for(int i = 0; i<len; i++){
			for(int j = 0; j<len; j++){
				if(i == j)sum += data_[i][j];
			}
		}
		double overAll = sum /=len;
		return overAll;
	}

	
	String[][] createTable(){
		int len = element_.length;
		String[][] evalTable = new String[len+1][len+1];
		evalTable[0][0] = "%";
		for(int i=0; i<len; i++){
			evalTable[0][i+1] = element_[i];
			evalTable[i+1][0] = element_[i];
		}
		for(int i=0; i<len; i++){
			for(int j=0; j<len; j++){
				evalTable[i+1][j+1] = Double.toString(data_[i][j]);
			}
		}
		return evalTable;
	}
}
