package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * VectorSignalMessageの最小要素を出力するフィルタです
 * @author hiro
 */
public class VectorMinElementFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			double minValue = vsig.getVectorElement(0);
			for(int i=0; i<vsig.getVectorSize(); i++){
				if(vsig.getVectorElement(i) < minValue){
					minValue = vsig.getVectorElement(i);
				}
			}
			// output
			outputMessage(VectorSignalMessages.createScalar(vsig.getTime(),minValue));
		}else{
			outputMessage(message);
		}
	}
}
