package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * ベクトルの要素数が正しいものだけ出力します
 * @author hiro
 */
public class VectorChecker extends AbstractFilter {

	private boolean start_;
	private int vlen_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		start_ = true;
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			if(start_ == true){
				start_ = false;
				vlen_ = vsig.getVectorSize();
			}else{
				if(vlen_ == vsig.getVectorSize()){
					outputMessage(message);
				}
			}
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}

