package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;

/**
 * AbstractFilterを使ったフィルタのサンプル。
 * ベクトルの各要素に0.5を掛けて1を加算する。
 * @author iwasaki
 */
@RuntimeBeanInfo(
		inputPorts = { @PortInfo(name = "inputPort", classes = {VectorSignalMessage.class}) },
		outputPorts = { @PortInfo(name = "outputPort", classes = {VectorSignalMessage.class}) }
)
public class SampleFilter1 extends AbstractFilter {
	private double constantToMultiply_ = 0.5;
	private double constantToAdd_ = 1;
	
	/** このブロックの説明です。Block Class List や _ClassDescription プロパティに表示されます。 */
	public static String getRuntimeBeanDescription() { return Messages.SampleFilter1_description; }
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			double[] newValue=new double[vsig.getVectorSize()];
			for(int i=0;i<newValue.length;++i) newValue[i]=vsig.getVectorElement(i)*constantToMultiply_+constantToAdd_;
			// 結果を出力
			outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}
