package jp.hasc.hasctool.core.data;

/**
 * @author iwasaki
 */
public class LabelSignalMessage extends AbstractSignalMessage implements Comparable<LabelSignalMessage> {
	
	LabelSignalMessage(long time, Type type, LabelInfo labelInfo) {
		super(time);
		type_=type;
		labelInfo_=labelInfo;
	}
	
	public enum Type {
		BEGIN, END
	}

	private Type type_;
	
	private LabelInfo labelInfo_;
	
	public LabelInfo getLabelInfo() {
		return labelInfo_;
	}
	
	@Override
	public SignalMessage createDelayedElement(long delay) {
		return new LabelSignalMessage(getTime()+delay, type_, labelInfo_);
	}
	
	public Type getType() {
		return type_;
	}
	
	@Override
	public int compareTo(LabelSignalMessage rhs) {
		{
			long ld=this.getTime() - rhs.getTime();
			if (ld!=0) return (ld<0)?-1:1;
		}{
			int d=this.type_.compareTo(rhs.type_);
			if (d!=0) return d;
		}{
			int d;
			if (this.labelInfo_==null) {
				if (rhs.labelInfo_==null) d=0;
				else d=-1;
			}else {
				if (rhs.labelInfo_==null) d=1;
				else d=this.labelInfo_.compareTo(rhs.labelInfo_);
			}
			return d;
		}
	}
	
	@Override
	public String toString() {
		return "LabelSignal{time:"+getTime()+",type:"+type_+","+labelInfo_+"}";
	}

	public static LabelSignalMessage createEmpty(long l) {
		return new LabelSignalMessage(l, Type.BEGIN, null);
	}

	/** auto generated */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((labelInfo_ == null) ? 0 : labelInfo_.hashCode());
		result = prime * result + ((type_ == null) ? 0 : type_.hashCode());
		return result;
	}

	/** auto generated */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		LabelSignalMessage other = (LabelSignalMessage) obj;
		if (labelInfo_ == null) {
			if (other.labelInfo_ != null)
				return false;
		} else if (!labelInfo_.equals(other.labelInfo_))
			return false;
		if (type_ == null) {
			if (other.type_ != null)
				return false;
		} else if (!type_.equals(other.type_))
			return false;
		return true;
	}

}
