package jp.hasc.hasctool.core.blockdiagram.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;

import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import junit.framework.TestCase;

/**
 * @author iwasaki
 */
public class BlockDiagramExecutorTest extends TestCase{
	
	public void test1() throws InterruptedException, ExecutionException {
		BlockDiagramExecutor exec=new BlockDiagramExecutor();
		RuntimeContext runtimeContext = exec.getRuntimeContext();
		
		// mock file system
		String testString="Hello,"+getLineSeparator()+"world."+getLineSeparator();
		final ByteArrayOutputStream baout=new ByteArrayOutputStream();
		final ByteArrayInputStream bain=new ByteArrayInputStream(testString.getBytes(RuntimeContext.DEFAULT_CHARSET));
		runtimeContext.setFileStreamProvider(new FileStreamProvider() {
			
			@Override
			public OutputStream openOutputStream(String fileName){
				if (fileName.equals(XStreamTest.OUTPUT_FILE_NAME)) {
					return baout;
				}else return null;
			}
			
			@Override
			public InputStream openInputStream(String fileName){
				if (fileName.equals(XStreamTest.INPUT_FILE_NAME)) {
					return bain;
				}else return null;
			}

			@Override
			public void listFileNames(String folderPath, List<String> out) {
			}

			@Override
			public void listSubFolderNames(String folderPath, List<String> out) {
			}
		});
		
		//
		BlockDiagram bd = XStreamTest.createSampleDiagram();
		exec.execute(bd);
		runtimeContext.awaitTasksTermination();
		//
		
		String resultString = new String(baout.toByteArray(),RuntimeContext.DEFAULT_CHARSET);
		assertEquals(testString, resultString);
		
	}

	private String getLineSeparator() {
		return System.getProperty("line.separator","\n");
	}

}
