package jp.hasc.hasctool.core.runtime.filter.weka.label;

import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 入力 ： time,label から
 * ラベルファイル(.label)情報を生成します
 * @author hiro
 */
public class EvalLabelingFilter extends AbstractFilter{

	private String label_ = "label";
	private double endTime_ = -1.0;
	private LabelInfo currentLabelInfo_=null;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] val = s.split(",");
			double time = Double.parseDouble(val[0]) * 1000000.0;
			if(!(val[1].equals(label_))){
				if(endTime_ != -1.0){
					outputMessage(currentLabelInfo_.createEndMessage((long)endTime_));
				}
				label_ = val[1];
				currentLabelInfo_=new LabelInfo(label_);
				outputMessage(currentLabelInfo_.createBeginMessage((long)time));
				endTime_ = time;
			} else {
				endTime_ = time;
			}
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}
}
