package jp.hasc.hupserver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class HUPMaster extends Frame implements ActionListener {
	/**
	 * 
	 */
	private static final long serialVersionUID = 8667360520300687653L;
	private static final int MAX = 20;
	private static final int NUM = 6;
	
    private TextArea tArea_ = new TextArea("",5,15);
//    private TextField tField_ = new TextField(15);
//    private Menu fMenu_;
    int counts[]= new int[NUM];
    int myPort;
    HUPSimpleServer servers[] = new HUPSimpleServer[NUM];
    private List list_ = new List(NUM, false);
    private List list2_ = new List(NUM, false);
    /*{
	    public Dimension getPreferredSize() {
		    return new Dimension(this.getSize().width/2,10);
	    }
	};*/
	
   final private Menu createFileMenu(){
		Menu fileMenu = new Menu("File");
//		fileMenu.addSeparator();
		fileMenu.add("restart Server");
		fileMenu.addSeparator();
		fileMenu.add("Quit");
//		fileMenu.add("Close Window");
		return fileMenu;
   }
   int port_=10000;
   
	public void init(int i){ // initialize GUI
		port_ +=i;
		setTitle("HASC UDP Proxy  "+i);
		setSize(400,200);
		setBackground(Color.lightGray);
//		tField_.setSize(20, 100);/
//		Panel p = new Panel();
//		p.add(tField_);
//		add("North", p);
		add("South", tArea_);
		this.setLocation(20+((i-1)/3)*400,50+200*((i-1)%3));

		enableEvents(WindowEvent.WINDOW_CLOSING);
		Menu fileMenu = createFileMenu();
		fileMenu.addActionListener(this);

		add("Center", list_);
		add("East", list2_);

		MenuBar menuBar = new MenuBar();
		menuBar.add(fileMenu);
		setMenuBar(menuBar);
		
		setVisible(true);
	}
	
    final public void processWindowEvent(WindowEvent we){
    	int id = we.getID();
    	if (id == WindowEvent.WINDOW_CLOSING){
    	    close();
    	}
    }
    
    final public void actionPerformed(ActionEvent ae){
    	String what=ae.getActionCommand();
    	if("Quit".equals(what)){
                quit();
    	}else if("restart Server".equals(what)){
//    		addNewServer();
    		restartServer();
    	}else if("Close Window".equals(what)){
    	    close();
    	}
    }
    final protected void quit() {
        dispose();
    }
    final protected void close(){
          setVisible(false);
          quit();
    }
    
    int ids_ = 0;
    void addNewServer(){
    	servers[ids_] = new HUPSimpleServer(port_+MAX+myPort,port_+myPort, this,ids_); 
    	counts[ids_]= 0;
    	list2_.add(""+counts[ids_],ids_);
    	list_.add(""+port_+" -> " +(port_+MAX));
//    	port_++;    	
    	new Thread(	servers[ids_]).start();
 //   	ids_++;
    }
    void restartServer(){
    	servers[0].stopServer();
    	list2_.removeAll();
    	list_.removeAll();
 
    	servers[0] = new HUPSimpleServer(port_+MAX,port_, this,ids_); 
    	counts[ids_]= 0;
    	list2_.add(""+counts[ids_],ids_);
    	list_.add(""+port_+" -> " +(port_+MAX));
//    	port_++;    	
    	new Thread(	servers[ids_]).start();
 //   	ids_++;
    }

    
    
    void countUp(int id, int size){
    	counts[id]+=size;
    	synchronized(this){
    	list2_.remove(id);
    	list2_.add(""+counts[id],id);
    	}
    }

    final public void logln(String str) {
    	System.out.println(str);
        tArea_.append(str + "\n");
        repaint();
    }
    
    public static void main(String[] args) {
		for(int i = 1; i < 1+NUM; i++){
			HUPMaster hup = new HUPMaster();
			hup.init(i);
			hup.addNewServer();
		}
//		HUPServer hsv = new HUPServer();
//		new Thread(hsv).start();
	}


}
