# -*- coding: utf-8 -*-
#
# Babel Language Pack に含まれている fragment plugin のうち、対象のfeatureに適用できるものをリストアップします。
# プラットフォーム依存のplugin等は、後から手動で取り除いて下さい（feature.xmlをEclipseで開いた時に、pluginタブに警告マークが出る）。
# 更新した場合、features.xmlのversion番号も変更して下さい。
# Usage:
#   ruby pick_babel_plugins.rb ECLIPSE_APP_ROOT/features/org.eclipse.babel.nls_*/feature.xml -t EXPORTED_APP_ROOT/artifact.xml

require 'set'
require "rexml/document"
@babel_plugins = []
@target_plugins = Set.new

target_arg_mode=false
ARGV.each do |arg|
	if arg=="-t"
		target_arg_mode=true
		next
	end
	doc = REXML::Document.new open(arg)
	list = target_arg_mode ? @target_plugins : @babel_plugins
	if (arg =~ /feature\.xml$/ )
		doc.elements.each("feature/plugin") { |e| list << e.attributes["id"] }
	elsif (arg =~ /artifacts\.xml$/ )
		doc.elements.each("repository/artifacts/artifact") { |e| list << e.attributes["id"] 
		#if e.attribytes["classifier"]="osgi.bundle"
		}
	else
		STDERR.puts "[ERROR] Unknown file type: #{arg}"
	end
end

@babel_plugins.each do |bid|
	if bid=~/^(.+)\.nl_[a-z]+$/
		tid=$1
		if @target_plugins.include?(tid)
			puts <<____
   <plugin
         id="#{bid}"
         download-size="0"
         install-size="0"
         version="0.0.0"
         fragment="true"/>

____
		end
	else
		STDERR.puts "[WARN] Unknown format plugin id: #{bid}"
	end
end
