package jp.hasc.hasctool.ui.bdeditor2.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * IPropertySourceのプロパティに値をセットするCommandです
 * @author iwasaki
 */
public class SetPropertyValueCommand extends Command {
	private IPropertySource target_;
	private Object id_;
	private Object oldValue_;
	private Object newValue_;
	private boolean executed_ = false;
	
	public SetPropertyValueCommand(IPropertySource target, Object id,
			Object oldValue, Object newValue) {
		super();
		target_ = target;
		id_ = id;
		oldValue_ = oldValue;
		newValue_ = newValue;
	}
	
	@Override
	public boolean canExecute() {
		return !executed_;
	}

	@Override
	public boolean canUndo() {
		return executed_;
	}
	
	@Override
	public void execute() {
		redo();
	}

	@Override
	public void redo() {
		target_.setPropertyValue(id_, newValue_);
		executed_ = true;
	}

	@Override
	public void undo() {
		target_.setPropertyValue(id_, oldValue_);
		executed_ = false;
	}
}
