package jp.hasc.hasctool.ui.views.grapheditor;

import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * Connection用のController Object
 * @author iwasaki
 */
public class ConnectionObject implements IPropertySource {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(ConnectionObject.class);
	
	private BlockDiagramGraphWidget bdg_;
	private Connection connection_;
	
	public ConnectionObject(BlockDiagramGraphWidget bdg, Connection connection) {
		super();
		bdg_ = bdg;
		connection_ = connection;
	}
	
	@Override
	public Object getEditableValue() {
		return null;
	}

	private final static String P_TYPE = "P_TYPE";
	private final static String P_COMMENT = "P_COMMENT";
	private final static String P_OUTPUT_PORT = "P_OUTPUT";
	private final static String P_INPUT_PORT = "P_INPUT";

	@Override
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptor = new IPropertyDescriptor[]{
				new TextPropertyDescriptor(P_TYPE,"_Type"),
				new TextPropertyDescriptor(P_COMMENT,"Comment"),
				new TextPropertyDescriptor(P_OUTPUT_PORT,"OutputPort"),
				new TextPropertyDescriptor(P_INPUT_PORT,"InputPort")
		};
		return descriptor;
	}

	@Override
	public Object getPropertyValue(Object id) {
		if(P_TYPE.equals(id)){
			return "Connection";
		}else if(P_COMMENT.equals(id)){
			return connection_.getComment()!=null?connection_.getComment():"";
		}else if(P_OUTPUT_PORT.equals(id)){
			return connection_.getOutputPortReference().getPortName();
		}else if(P_INPUT_PORT.equals(id)){
			return connection_.getInputPortReference().getPortName();
		}
		return null;
	}

	@Override
	public boolean isPropertySet(Object id) {
		return false;
	}

	@Override
	public void resetPropertyValue(Object id) {
	}

	@Override
	public void setPropertyValue(Object id, Object value) {
		LOG.debug("setPropertyValue: "+id+"="+value);
		
		String valueStr=value!=null?value.toString():"";
		if(P_COMMENT.equals(id)){
			connection_.setComment(valueStr.isEmpty()?null:valueStr);
			bdg_.updateText();
		}else if(P_OUTPUT_PORT.equals(id)){
			if (!valueStr.isEmpty()) {
				BeanBlock blk = (BeanBlock)bdg_.getContentProvider().getBlockObjMap().get(connection_.getOutputPortReference().getBlockName()).getBlock();
				connection_.setOutputPortReference(blk.getPortByName(valueStr));
				bdg_.updateText();
			}
		}else if(P_INPUT_PORT.equals(id)){
			if (!valueStr.isEmpty()) {
				BeanBlock blk = (BeanBlock)bdg_.getContentProvider().getBlockObjMap().get(connection_.getInputPortReference().getBlockName()).getBlock();
				connection_.setInputPortReference(blk.getPortByName(valueStr));
				bdg_.updateText();
			}
		}
	}

	public Connection getConnection() {
		return connection_;
	}
}
