package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.core.messaging.MessageProcessor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * SpectrogramViewにデータを転送するBean
 * @author hiro,iwasaki
 */
public class RuntimeSpectrogramView extends AbstractRuntimeSpectrogramView {
	private SpectrogramView spectrogramView_;
	
	protected void setupView(IWorkbenchWindow window, String keyName) throws Exception {
		spectrogramView_=(SpectrogramView) window.getActivePage().showView(SpectrogramView.ID
				,keyName, IWorkbenchPage.VIEW_VISIBLE);
		SpectrogramViewWidget spectrogramViewWidget = spectrogramView_.getSpectrogramViewWidget();
		spectrogramViewWidget.setTitleName(keyName);
		spectrogramViewWidget.setValueMin(getMinValue());
		spectrogramViewWidget.setValueHeight(getMaxValue()-getMinValue());
		spectrogramViewWidget.setFrequency(getFrequency());
	}
	
	public MessageProcessor getInputPort() {
		return spectrogramView_.getInputPort();
	}
}
