package jp.hasc.hasctool.ui.commands;

import java.util.Iterator;

import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.util.UIUtil;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * @author iwasaki
 */
public class ConvertAudioFileCommand extends AbstractHandler {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(ConvertAudioFileCommand.class);

	public static final String ID_COMMAND="jp.hasc.hasctool.ui.commands.ConvertAudioFileCommand"; //$NON-NLS-1$

	@SuppressWarnings("unchecked")
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		// Navigator上での選択されたファイルを列挙
		try{
			ISelection selection = HandlerUtil.getCurrentSelection(event);
			if (selection instanceof StructuredSelection) {
				StructuredSelection ss = (StructuredSelection) selection;
				for (Iterator<Object> it = ss.iterator(); it.hasNext();) {
					Object item = it.next();
					if (item instanceof IFile) {
						IFile f=(IFile)item;
						CoreUtil.convertAudioFile(f);
					}
				}
			}
			UIUtil.showMessageDialog(HandlerUtil.getActiveShell(event), Messages.ConvertAudioFileCommand_Executed);
		}catch(Exception ex) {
			LOG.warn("Exception",ex); //$NON-NLS-1$
			UIUtil.showMessageDialog(HandlerUtil.getActiveShell(event),"[Exception]\n"+ex.toString()); //$NON-NLS-1$
		}
		return null;
	}
}
