package jp.hasc.hasctool.core.runtime.source;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;

/**
 * サイン波を、ScalarSignalMessageとして出力する信号ソースです
 * @author iwasaki
 */
@RuntimeBeanInfo(
		outputPorts = { @PortInfo(name = "outputPort", classes = {ScalarSignalMessage.class}) }
)
public class SinWaveGenerator extends AbstractSource {

	private long cycle_;
	private long tickBegin_=0;
	private long tickEnd_;
	private long tickInterval_;
	private double thetaOffset_=0;
	
	@Override
	protected void run() throws InterruptedException {
		long time=tickBegin_;
		outputMessage(SignalMessage.BEGIN);
		for(;time<tickEnd_ && !isShutdown() ; time+=tickInterval_) {
			double val=Math.sin(2*Math.PI*time/cycle_ + thetaOffset_);
			outputMessage(new ScalarSignalMessage(time, val));
		}
		outputMessage(SignalMessage.END);
	}
	
	public long getCycle() {
		return cycle_;
	}

	public void setCycle(long cycle) {
		cycle_ = cycle;
	}

	public long getTickEnd() {
		return tickEnd_;
	}

	public void setTickEnd(long tickEnd) {
		tickEnd_ = tickEnd;
	}

	public long getTickInterval() {
		return tickInterval_;
	}

	public void setTickInterval(long tickInterval) {
		tickInterval_ = tickInterval;
	}

	public double getThetaOffset() {
		return thetaOffset_;
	}

	public void setThetaOffset(double offset) {
		thetaOffset_ = offset;
	}

	public long getTickBegin() {
		return tickBegin_;
	}

	public void setTickBegin(long tickBegin) {
		tickBegin_ = tickBegin;
	}

}
