package jp.hasc.hasctool.core.runtime.sink;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.hasc.hasctool.core.runtime.RuntimeContext;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

/**
 * 入力されたオブジェクト系列を、XStreamでシリアライズし、commons loggingのLOGに出力します
 * @author iwasaki
 */
public class XStreamLogSink extends AbstractSink {
	private XStream xStream_;
	private Log logger_;
	private String tag_=XStreamLogSink.class.getName();
	
	public static XStream createXStreamForLogging() {
		XStream xStream = new XStream(new DomDriver());
		xStream.autodetectAnnotations(true);
		return xStream;
	}
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		xStream_ = createXStreamForLogging();
		logger_=LogFactory.getLog(tag_);
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		String str=xStream_.toXML(message);
		logger_.info(str);
	}

	public void setTag(String tag) {
		tag_ = tag;
	}
}
