package jp.hasc.hasctool.core.runtime.script;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 外部のScriptファイルを実行できる、１入力１出力Filterです。１入力Sinkの代わりにも使えます。
 * @author iwasaki
 */
public class ScriptFilter extends AbstractFilter {
	
	private String scriptLanguage_ = ScriptSupport.LANGUAGE_JAVASCRIPT;
	private ScriptSupport scriptSupport_;
	private String scriptPath_;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		//
		scriptSupport_=new ScriptSupport(scriptLanguage_);
		scriptSupport_.setup(this,scriptPath_);
	}

	public void setScriptLanguage(String language) {
		scriptLanguage_ = language;
	}
	
	public void setScriptPath(String filePath) {
		scriptPath_=filePath;
	}
	
	//
	@Override
	public void processMessage(Object message) throws InterruptedException {
		scriptSupport_.invokeFunction("processMessage", message);
	}
	
	@Override
	public void outputMessage(Object message) throws InterruptedException {
		super.outputMessage(message);
	}
}
