package jp.hasc.hasctool.core.runtime.filter.time;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 計測開始時刻を０とした相対時刻に修正するフィルタです
 * @author hiro
 */

public class RelativeTimeFilter extends AbstractFilter{
	
	private long startTime_;//開始時刻
	private boolean start_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		start_ = true;
	}

	long getReTime(long val){
		return val-startTime_;
	}

	long timeParse(long val){
		long hour = (int)(val/10000000);
		long minute = (int)(val/100000) - hour*100;
		long msec = val - (hour*10000000 + minute*100000);
		return hour*3600*1000 + minute*60*1000 + msec;
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			double[] newValue=new double[vsig.getVectorSize()];
			for(int i=0; i<newValue.length; ++i){
				newValue[i] = vsig.getVectorElement(i);
			}
			if(start_){
				startTime_ = vsig.getTime();
				start_ = false;
			}
			//TimeParserを実行する
			long newTime = getReTime(vsig.getTime());
			// 結果を出力
			outputMessage(VectorSignalMessages.create(newTime, newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}


}
