package jp.hasc.hasctool.core.runtime.filter.interpolator;

import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * 時間的に最も近いSignalMessageを、timeのみ変更して返すSignalInterpolatorです
 * @author iwasaki
 */
public class NearestInterpolator implements SignalInterpolator {
	
	private SignalMessage previous_=null, next_=null;

	@Override
	public boolean addSample(SignalMessage message) {
		previous_=next_;
		next_=message;
		return true;
	}

	@Override
	public SignalMessage getAtTime(long time) {
		SignalMessage tgt=null;
		tgt=(previous_==null) || (Math.abs(time-previous_.getTime()) >= Math.abs(next_.getTime()-time)) ? next_ : previous_;
		if (tgt==null) return null;
		//return tgt;
		return tgt.createDelayedElement(time-tgt.getTime());
	}

}
