package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * VectorSignalMessageを、ComplexVectorSignalMessageとして出力するフィルタです
 * @author hiro
 */
public class VectorToComplexFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			int length = vsig.getVectorSize();
			Complex[] newValue = new Complex[length];
			for(int i=0; i<length; i++){
				newValue[i] = new Complex(vsig.getVectorElement(i), 0.0); 
			}
			// output
			outputMessage(new ComplexVectorSignalMessage(vsig.getTime(), newValue, true));
		}else{
			outputMessage(message);
		}
	}

}
