package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * ComplexVectorSignalMessageを、VectorSignalMessageとして出力するフィルタです
 * @author hiro
 */
public class ComplexToVectorFilter extends AbstractFilter {


	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ComplexVectorSignalMessage) {
			VectorSignalMessage cvsig = (VectorSignalMessage) message;
			int length = cvsig.getVectorSize();
			double[] newValue = new double[length];
			for(int i=0; i<length; i++){
			  newValue[i] = ((ComplexVectorSignalMessage)cvsig).getVectorElement(i);
			}
			// output
			outputMessage(VectorSignalMessages.create(cvsig.getTime(), newValue));
		 }else{
			outputMessage(message);
		}
	}
}
